/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.hscmgt;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.launch.hscmgt.EssSaveUpgradeException;
import com.ibm.hsc.websm.launch.hscmgt.Saveupgrade;
import com.ibm.hsc.websm.launch.hscmgt.SaveupgradeFile;
import com.ibm.hsc.websm.launch.hscmgt.SaveupgradeObject;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.PropertyResourceBundle;

public class SaveEssExtensionUpgradeData
implements Saveupgrade {
    private static final String TRACE_MASKD = "EMMSVUPD";
    private static final String TRACE_MASKF = "EMMSVUPF";
    private static final String TRACE_MASKT = "EMMSVUPT";
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, 101, "SaveEssHMCUpgradeData");
    private static final short ERRID_000E = 14;
    private static final short ERRID_000F = 15;
    private static final String HSC_DO_CMD_EXECUTABLE = "/opt/hsc/bin/hscdc";
    private static final String _version = "1.0";
    private SaveupgradeFile suf;

    public SaveEssExtensionUpgradeData() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "SaveEssExtensionUpgradeData - Constructor");
        }
        this.suf = new SaveupgradeFile();
    }

    private void collectUpgradeFiles() {
        File file;
        File file2;
        File file3;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "SaveEssExtensionUpgradeData:collectUpgradeFiles()->");
        }
        if ((file3 = new File("/var/esshmc/log")) != null && file3.isDirectory()) {
            this.recurseDir(file3);
        }
        if ((file2 = new File("/var/essni/logs")) != null && file2.isDirectory()) {
            this.recurseDir(file2);
        }
        if ((file = new File("/var/ct.backup")) != null && file.isDirectory()) {
            this.recurseDir(file);
        }
        this.checkAndAddFile("/opt/esshmc/data/hmcprimary");
        this.checkAndAddFile("/opt/esshmc/data/hmcsecondary");
        this.checkAndAddFile("/opt/esshmc/data/hmclabmode");
        this.checkAndAddFile("/opt/esshmc/data/hmcnetservices");
        this.checkAndAddFile("/var/ct/cfg/ctrmc.acls");
        this.checkAndAddFile("/etc/httpd/httpd.conf.base");
        this.checkAndAddFile("/var/websm/config/user_settings/websm.cfg.base");
        this.checkAndAddFile("/opt/hsc/data/hmcType.properties.base");
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "SaveEssExtensionUpgradeData:collectUpgradeFiles()<-");
        }
    }

    private void checkAndAddFile(String string) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            this.suf.addFile(string);
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "add file: " + string);
            }
        } else {
            Trace.trace(TRACE_MASKF, string + " does not exist or not a file");
        }
    }

    private void recurseDir(File file) {
        block6: {
            try {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (fileArray[i].isDirectory()) {
                            this.recurseDir(fileArray[i]);
                            continue;
                        }
                        if (fileArray[i].exists() && fileArray[i].isFile()) {
                            this.suf.addFile(fileArray[i].getAbsolutePath());
                            if (Trace.LEVEL < 3) continue;
                            Trace.trace(TRACE_MASKD, "add file: " + file);
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, file + " does not exist or not a file");
                    }
                }
            }
            catch (Exception exception) {
                if (2 > Trace.LEVEL) break block6;
                Trace.trace(TRACE_MASKF, "caught exception in recurseDir() <" + exception + ">");
            }
        }
    }

    public SaveupgradeObject[] getSaveupgradeObjects() {
        String string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "SaveEssExtensionUpgradeData:getSaveupgradeObjects->");
        }
        PropertyResourceBundle propertyResourceBundle = null;
        try {
            propertyResourceBundle = new PropertyResourceBundle(new FileInputStream("/opt/hsc/data/hmcType.properties"));
            string = propertyResourceBundle.getString("HMCTYPE");
            if (string.equals("ipHMC")) {
                throw new EssSaveUpgradeException("this class does not do anything for ip HMC");
            }
        }
        catch (IOException iOException) {
            Trace.trace(TRACE_MASKF, "IOException caught accessing hmcType file: " + iOException.getMessage());
        }
        catch (SecurityException securityException) {
            Trace.trace(TRACE_MASKF, "SecurityException caught accessing hmcType file: " + securityException.getMessage());
        }
        string = "/opt/hsc/bin/hscdc " + Crypt.encrypt("/usr/sbin/rsct/bin/ctbackup");
        EExecResult eExecResult = EExec.Exec((String)string);
        if (eExecResult.rc == 0 && 3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "ctbackup runs successfully");
        }
        this.collectUpgradeFiles();
        SaveupgradeObject[] saveupgradeObjectArray = new SaveupgradeObject[]{this.suf};
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "SaveEssExtensionUpgradeData:getSaveupgradeObjects<-");
        }
        return saveupgradeObjectArray;
    }

    public String getVersion() {
        return _version;
    }

    public void saveupgradeComplete() {
    }

    public void restoreComplete(String string) {
    }

    private static String executeCommandGetStdOut(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SaveEssExtensionUpgradeData.executeCommandGetStdOut()");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "   about to attempt " + string);
        }
        String string2 = "";
        EExecResult eExecResult = EExec.Exec((String)string);
        if (eExecResult.rc == 0) {
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Data returned is <" + eExecResult.stdout + ">");
            }
            if (eExecResult.stdout != null) {
                string2 = eExecResult.stdout;
            } else if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "command returned successfully, but with no data");
            }
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "command returned non-zero return code, rc = " + eExecResult.rc);
                Trace.trace(TRACE_MASKF, "stderr data is <" + eExecResult.stderr.trim() + ">");
            }
            AusMicrocodeLog ausMicrocodeLog = new AusMicrocodeLog(_logInfo, 14);
            ausMicrocodeLog.add("command " + string + " execution error, rc = " + eExecResult.rc);
            ausMicrocodeLog.writeEntry(null);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SaveEssExtensionUpgradeData.executeCommandGetStdOut()");
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        SaveEssExtensionUpgradeData saveEssExtensionUpgradeData = new SaveEssExtensionUpgradeData();
        saveEssExtensionUpgradeData.collectUpgradeFiles();
        try {
            SaveupgradeObject[] saveupgradeObjectArray = saveEssExtensionUpgradeData.getSaveupgradeObjects();
        }
        catch (Exception exception) {
            System.out.println("Exception caught " + exception.getMessage());
        }
        System.out.println("done");
    }
}

